%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Classe de documento LaTeX para monografias da graduação
% Criado por: Eduardo Teles (eduardo.teles@cefet-rj.br)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{monografia}[2022/10/19 Monografia CEFET/RJ - UnED Petr\'{o}polis]


\LoadClass[a4paper, 14pt, oneside]{extbook}
%\LoadClass[a4paper, 14pt, oneside]{extreport}

\RequirePackage{amsmath, amsfonts, amssymb, amstext, amscd, bezier}
\RequirePackage{mathtools}
\RequirePackage{lastpage}
\RequirePackage{graphicx}

%\RequirePackage[crop=off,runs=2]{auto-pst-pdf}
%\RequirePackage{psfrag}


%\RequirePackage[crop=pdfcrop]{pstool}

\RequirePackage{fancyhdr}
\RequirePackage{float}
\RequirePackage{tocloft}
%\RequirePackage{forloop}
\RequirePackage{etoolbox}
\RequirePackage{xparse}
\RequirePackage{cancel}
\RequirePackage{multicol}
\RequirePackage{enumitem}
\RequirePackage{array}
\RequirePackage{tabularx}
\RequirePackage{titlesec}


%\RequirePackage{alltt}
\RequirePackage[linktocpage=true]{hyperref}
\RequirePackage{lipsum}


\RequirePackage[alf,bibjustif]{abntex2cite}
%\pdfstringdefDisableCommands{% desabilitando comandos proibidos no bookmarks
%	\let\MakeUppercase\relax%
%	\def\\{ }%
%}


%\RequirePackage{natbib}

%\RequirePackage{cite}
%\renewcommand{\citeleft}{(}
%\renewcommand{\citeright}{)}

\RequirePackage[english,brazil]{babel}
\RequirePackage[T1]{fontenc}
\RequirePackage[utf8]{inputenc}

\RequirePackage{xcolor}
%\RequirePackage[a4paper, left=3cm, right=3cm, top=3cm, bottom=3cm]{geometry}
\RequirePackage[a4paper, left=3cm, top=3cm, right=2cm,  bottom=2cm, inner=3cm, outer=2cm ]{geometry}
\RequirePackage{setspace}
\RequirePackage{indentfirst}
\setlength{\parindent}{1.25cm} % Comprimento da indentação da primeira linhas do parágrafo
\setlength{\parskip}{5mm} % Distância entre parágrafos
%\renewcommand{\baselinestretch}{1.5} % Multiplicador do espaçamento entre linhas de um parágrafo.
\onehalfspacing
%\doublespacing

\graphicspath{{./figuras/}}

\newtoggle{texfig}
\togglefalse{texfig}
\DeclareOption{texfig}{
	\toggletrue{texfig}
}

\newtoggle{repdiv}
\togglefalse{repdiv}
\DeclareOption{repdiv}{
	\toggletrue{repdiv}
}

\newtoggle{suplentes}
\togglefalse{suplentes}
\DeclareOption{suplentes}{
	\toggletrue{suplentes}
}

\newtoggle{agradecimentos}
\togglefalse{agradecimentos}
\DeclareOption{agradecimentos}{
	\toggletrue{agradecimentos}
}

\newtoggle{dedicatoria}
\togglefalse{dedicatoria}
\DeclareOption{dedicatoria}{
	\toggletrue{dedicatoria}
}

\newtoggle{epigrafe}
\togglefalse{epigrafe}
\DeclareOption{epigrafe}{
	\toggletrue{epigrafe}
}

\newtoggle{ilustracoes}
\togglefalse{ilustracoes}
\DeclareOption{ilustracoes}{
	\toggletrue{ilustracoes}
}

\newtoggle{tabelas}
\togglefalse{tabelas}
\DeclareOption{tabelas}{
	\toggletrue{tabelas}
}

\newtoggle{abreviaturas}
\togglefalse{abreviaturas}
\DeclareOption{abreviaturas}{
	\toggletrue{abreviaturas}
}

\newtoggle{simbolos}
\togglefalse{simbolos}
\DeclareOption{simbolos}{
	\toggletrue{simbolos}
}

\newtoggle{glossario}
\togglefalse{glossario}
\DeclareOption{glossario}{
	\toggletrue{glossario}
}

\newtoggle{apendice}
\togglefalse{apendice}
\DeclareOption{apendice}{
	\toggletrue{apendice}
}

\newtoggle{anexo}
\togglefalse{anexo}
\DeclareOption{anexo}{
	\toggletrue{anexo}
}

\newtoggle{indice}
\togglefalse{indice}
\DeclareOption{indice}{
	\toggletrue{indice}
}


\newtoggle{tituloa}
\togglefalse{tituloa}
\DeclareOption{tituloa}{
	\toggletrue{tituloa}
}

\newtoggle{titulob}
\togglefalse{titulob}
\DeclareOption{titulob}{
	\toggletrue{titulob}
}




%\DeclareOption{red}{\renewcommand{\headlinecolor}{\color{slcolor}}}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions\relax

\iftoggle{texfig}{\RequirePackage[crop=pdfcrop]{pstool}}{}

%shapes: hang, runin, display,block
%\titleformat{cmd}[shape]{format}{label}{sep}{before-code}[after-code]
%\titleformat{\section}[display]{\Large\scshape\centering}{\newpage\hrulefill\linebreak\scalebox{4}{\bf\thesection}}{0.0em}{\vspace*{-5mm}}[\vspace*{-11mm}\hrulefill]
%\titleformat{\section}[display]{\Large\scshape}{\newpage\hrulefill\\\scalebox{4}{\bf\thesection}}{0.5em}{}[.\quad]
%\titleformat{\section}[hang]{\Large\scshape}{\bf\thesection}{0.5em}{}

%\titleformat{\chapter}[display]{\Huge\bfseries\centering}{\vspace*{-30mm}\hrulefill\linebreak\scalebox{1.0}{\bfseries \chaptertitlename
%~\thechapter}}{0.0em}{}[\vspace*{-10mm}\hrulefill]


%\titleformat{\chapter}[display]%
%{\bfseries\Large\filcenter}%
%{\titlerule[1pt]%
%	\vspace{1pt}
%	\LARGE\scshape\chaptertitlename~\thechapter
%}%
%{0pt}%
%{\Large}%
%[\vspace{2ex}%
%{\titlerule[1pt]}]

%\iftoggle{titulob}{%
%	\titleformat{\chapter}[display]%
%	{\bfseries\Large\filcenter\titlerule[2pt]\vspace{1pt}}%
%	{\Huge\chaptertitlename~\thechapter}%
%	{2ex}%
%	{\titlerule[1pt]%
%		\vspace{1pt}%
%		\Large}%
%	[\vspace{2ex}%
%	{\titlerule[2pt]}]
%}{}


\iftoggle{tituloa}{%
	\titleformat{\chapter}[display]%
	{\bfseries\Large\filcenter\titlerule[1pt]\vspace{1pt}}%
	{\LARGE\scshape\chaptertitlename~\thechapter}%
	{0pt}%
	{\Large}%
	[\vspace{1.4ex}%
	{\titlerule[1pt]}]
}{
	\iftoggle{titulob}{%
		\titleformat{\chapter}[display]%
		{\bfseries\Large\filcenter%
			\hrule height 2pt \hrule height 4pt width 0.25\textwidth%
			\vspace{1pt}%
		}%
		{\Huge\chaptertitlename~\thechapter}%
		{2ex}%
		{\Large}%
		[\vspace{1pt}%
		{\moveright0.75\textwidth\vbox{\hrule height 4pt width 0.25\textwidth}%
		\hrule height 2pt}]
	}{}
}




%\titlespacing{\chapter}{0pt}{0pt}{0pt}

%\pagestyle{fancy}
%\pagestyle{myheadings}
%\pagestyle{plain}
\renewcommand{\headrulewidth}{0pt}
\renewcommand{\footrulewidth}{0pt}
%\fancyhead[RO,RE,LO,LE,CO,CE]{}
%\fancyfoot[RO,RE,LO,LE,CO,CE]{}
%\fancyhead[RO,LE]{\thepage}
\fancyhead[R,L,C]{}
\fancyfoot[R,L,C]{}
\fancyhead[R,L]{\thepage}


\fancypagestyle{plainTypeB}{
	\fancyhf{}%
	\renewcommand{\headrulewidth}{0pt}
	\renewcommand{\footrulewidth}{0pt}
	%\fancyfoot[C]{Pág.: \thepage\ de\ \pageref{LastPage}}
}


\renewcommand{\cfttoctitlefont}{\hspace*{\fill}\large\bfseries}
\renewcommand{\cftaftertoctitle}{\hspace*{\fill}}
\renewcommand{\cftlottitlefont}{\hspace*{\fill}\large\bfseries}
\renewcommand{\cftafterlottitle}{\hspace*{\fill}}
\renewcommand{\cftloftitlefont}{\hspace*{\fill}\large\bfseries}
\renewcommand{\cftafterloftitle}{\hspace*{\fill}}

%\patchcmd{\l@chapter}{#1}{\MakeUppercase{#1}}{}{}% Chapters use UPPERCASE in ToC
%\patchcmd{\l@chapter}{#1}{\MakeUppercase{#1}}{}{}% Chapters use UPPERCASE in ToC


\setlength{\cftbeforetoctitleskip}{-3em}
\setlength{\cftbeforeloftitleskip}{-3em}
\setlength{\cftbeforelottitleskip}{-3em}

\renewcommand{\cftfigfont}{Figura }
\renewcommand{\cfttabfont}{Tabela }

\renewcommand{\cftfigaftersnum}{ - }
\renewcommand{\cfttabaftersnum}{ - }

\DeclareMathOperator{\sen}{sen}
\DeclareMathOperator{\arcsen}{arcsen}
\DeclareMathOperator{\senh}{senh}
\DeclareMathOperator{\cotg}{cotg}
\DeclareMathOperator{\tg}{tg}
\DeclareMathOperator{\cosec}{cosec}
\DeclareMathOperator{\cotan}{cotan}

\newcommand{\cqd}{\text{ }\hfill $\rule{2mm}{2mm}$}
\newcommand{\fim}{\hfill $\Box$}

% Conjuntos
\newcommand{\C}{\ensuremath{\mathbb{C}}}
\newcommand{\R}{\ensuremath{\mathbb{R}}}
\newcommand{\Q}{\ensuremath{\mathbb{Q}}}
\newcommand{\Z}{\ensuremath{\mathbb{Z}}}
\newcommand{\N}{\ensuremath{\mathbb{N}}}


\newcommand{\instituicao}{Centro Federal de Educação Tecnológica Celso Suckow da Fonseca}
\newcommand{\siglaInstituicao}{CEFET/RJ}

\newcommand{\departamento}{Departamento de Pesquisa e Pós-Graduação}

\newcommand{\titulo}{Título do documento}
\newcommand{\tituloIngles}{Title of the document}
\newcommand{\autor}{Autor ou autora}
\newcommand{\citacaoAutor}{Autor ou autora}
\newcommand{\cidade}{Cidade - Estado}
\newcommand{\data}{Mês e Ano de defesa}
\newcommand{\mes}{Agosto}
\newcommand{\ano}{2017}


\newcommand{\curso}{Curso}
\newcommand{\tituloObtido}{licenciado em Matemática}
\newcommand{\orientador}{Orientador}
\newcommand{\orientadorCapa}{Orientador(a)}
\newcommand{\citacaoOrientador}{Autor ou autora}
\newcommand{\coorientador}{Coorientador}
\newcommand{\banca}{membro1;membro2;membro3}
\newcommand{\suplentes}{membro1;membro2;membro3}
\newcommand{\dedicatoria}{Quero agradecer...}
\newcommand{\agradecimentos}{Quero agradecer...}
\newcommand{\epigrafe}{A tecnologia não é boa nem má; nem tão pouco neutra.\\1ª lei de Melvin Kranzberg}

\newcommand{\resumo}{Elemento obrigatório, constituído de um único parágrafo contendo uma sequência de frases concisas e objetivas e não de uma simples enumeração de tópicos. Sua extensão deve conter de 150 a 500 palavras, digitado em espaço simples.}
\newcommand{\palavrasChave}{Palavra1; Palavra2; Palavra3}

\newcommand{\resumoIngles}{Here it goes the abstract in English. Here it goes the abstract in English. Here it goes the abstract in English. Here it goes the abstract in English. Here it goes the abstract in English. Here it goes the abstract in English. Here it goes the abstract in English. Here it goes the abstract in English. Here it goes the abstract in English. Here it goes the abstract in English. Here it goes the abstract in English.}
\newcommand{\palavrasChaveIngles}{(mínimo de três e máximo de cinco, primeira letra maiúscula, separado por ponto e vírgula)}


\newcommand{\listasimbolos}{
\begin{flushleft}
	\begin{tabularx}{\textwidth}{>{\centering}p{15mm}X}
		$\R$ & Conjunto dos números reais \\ 
		$\mathcal{M}_n$ & Conjunto das matrizes quadradas de ordem~$n$
	\end{tabularx} 	
\end{flushleft}
}

\newcommand{\listaabreviacoes}{
	\begin{flushleft}
		\begin{tabularx}{\textwidth}{>{\raggedright}p{30mm}X}
			ABNT & Associação Brasileira de Normas Técnicas \\ 
			OAB & Ordem dos Advogados do Brasil \\
			ONU & Organização das Nações Unidas 
		\end{tabularx} 	
	\end{flushleft}
}

\newcounter{palavrasChaveCont}
\setcounter{palavrasChaveCont}{1}

\NewDocumentCommand{\palavrasChaveNumeradas}{m}{\expandafter\palavrasChaveNumeradasSplit\expandafter{#1}}
\NewDocumentCommand{\palavrasChaveNumeradasSplit}{ >{\SplitList{;}} m }{%
	\ProcessList{#1}{\numerar}%
}
\NewDocumentCommand{\numerar}{m}{\stepcounter{palavrasChaveCont}\arabic{palavrasChaveCont}.~#1. }


\NewDocumentCommand{\gerarBanca}{m}{\expandafter\gerarBancaSplit\expandafter{#1}}

\NewDocumentCommand{\gerarBancaSplit}{ >{\SplitList{;}} m }{%
	\ProcessList{#1}{\assinatura}%
}

\NewDocumentCommand{\assinatura}{m}{%
	\par\noindent\rule{\textwidth}{0.4pt}\\
	#1\\[8mm]
}


\newcommand{\textoA}{Trabalho de Conclusão de Curso apresentado ao Curso de \curso, do Centro Federal de Educação Tecnológica Celso Suckow da Fonseca, CEFET/RJ \emph{campus}~\cidade, como parte dos requisitos necessários à obtenção do título de \tituloObtido.}

\newcommand{\pretextuais}{%
%%%%%%%%%%%%%%%%%%%% CAPA %%%%%%%%%%%%%%%%%%%% Não numerada. Esta é a página 0.
%\thispagestyle{empty}
%\begin{center}
%	\MakeUppercase{\titulo}
%\end{center}
%\vfill
%\begin{center}
%	\autor
%\end{center}
%\vfill
%\hfill\noindent\parbox[t]{11cm}{\textoA.\\[2cm]
%	Orientador(a): \orientador
%}
%\vfill
%\begin{center}
%	\cidade\\
%	\data
%\end{center}
%%%%%%%%%%%%%%%%%%%% FOLHA DE ROSTO %%%%%%%%%%%%%%%%%%%% Não numerada. Esta é a página 1.
\thispagestyle{empty}
\begin{center}
	\includegraphics[scale=0.6]{logoCefetCampusPetropolis}
\end{center}
\begin{center}
\bf\Large\MakeUppercase{\titulo}
\end{center}
\vfill
\begin{center}
\autor
\end{center}
\vfill
\hfill\noindent\parbox[t]{11cm}{\textoA\\[2cm]
\orientadorCapa: \orientador
}
\vfill
\begin{center}
\cidade\\
\data
\end{center}
%%%%%%%%%%%%%%%%%%%% FOLHA DE ASSINATURAS %%%%%%%%%%%%%%%%%%%%
\newpage
\thispagestyle{empty}
\begin{center}
	\MakeUppercase{\titulo}
\end{center}
\bigskip
\makebox[1.25cm]{}\textoA\par
\bigskip
\begin{center}
	\autor
\end{center}
\bigskip
\noindent Banca examinadora:\\
\begin{center}
\par\gerarBanca{\banca}
\end{center}

\iftoggle{suplentes}{%
	%
	\noindent Suplentes:\\
	\begin{center}
		\par\gerarBanca{\suplentes}
	\end{center}
}{%
	
}
\vfill
\begin{center}
	\cidade\\
	\data
\end{center}
%%%%%%%%%%%%%%%%%%%% FICHA CATALOGRÁFICA %%%%%%%%%%%%%%%%%%%%
\newpage
\thispagestyle{empty}
\begin{center}
	\iftoggle{repdiv}{%
		Autorizo a reprodução e divulgação total ou parcial deste trabalho, por qualquer meio eletrônico ou convencional, para fins de estudo e pesquisa, desde que citada a fonte.
	}{%
		Nenhuma parte deste trabalho pode ser reproduzida ou divulgada, em qualquer meio eletrônico ou convencional, sem autorização do(a) autor(a).
	}
\end{center}
\vfill
\hfill\parbox[t]{0.8\textwidth}{%
	\begin{flushright}
		Ficha catalográfica
	\end{flushright}
}\par
\hfill\fbox{\parbox[t]{0.8\textwidth}{%
\citacaoAutor\par
\bigskip
\makebox[1.25cm]{} \titulo\ / \autor; orientador: \orientador\ --- \cidade: \siglaInstituicao, \departamento, \ano.\par
\bigskip
\makebox[1.25cm]{} v.,~\pageref{LastPage}~f:~il.~;~29,7~cm\par
\bigskip
\makebox[1.25cm]{} Inclui referências bibliográficas.\par
\bigskip
\makebox[1.25cm]{} 1.~Matemática -- Monografia. \palavrasChaveNumeradas{\palavrasChave} I.~\citacaoOrientador. II.~\instituicao. III.~Título.
}}\par
\bigskip
\bigskip
\hfill\parbox[t]{0.8\textwidth}{%
\begin{flushright}
	CDD:~510
\end{flushright}
}
\vfill
%\hfill\noindent\parbox[t]{11cm}{\dedicatoria\\[2cm]}
%\newpage


%%%%%%%%%%%%%%%%%%%% DEDICATÓRIA %%%%%%%%%%%%%%%%%%%%
\iftoggle{dedicatoria}{%
	\newpage
	\thispagestyle{empty}
	\begin{center}
		\large\bfseries\MakeUppercase{Dedicatória}
	\end{center}
	\vfill
	\hfill\noindent\parbox[t]{11cm}{\dedicatoria\\[2cm]}
	%\newpage
}{%

}
%%%%%%%%%%%%%%%%%%%% AGRADECIMENTOS %%%%%%%%%%%%%%%%%%%%
\iftoggle{agradecimentos}{%
	\newpage
	\thispagestyle{empty}
	\begin{center}
		\large\bfseries\MakeUppercase{Agradecimentos}
	\end{center}
	\agradecimentos
	\newpage
}{%

}
%%%%%%%%%%%%%%%%%%%% EPÍGRAFE %%%%%%%%%%%%%%%%%%%%
\iftoggle{epigrafe}{%
	\newpage
	\thispagestyle{empty}
	\begin{center}
		\large\bfseries\MakeUppercase{Epígrafe}
	\end{center}
	\vfill
	\hfill\noindent\parbox[t]{11cm}{
		\begin{flushright}
			\epigrafe\\[2cm]
		\end{flushright}
	}
	\newpage
}{%

}
%%%%%%%%%%%%%%%%%%%% RESUMO %%%%%%%%%%%%%%%%%%%%
\newpage
\thispagestyle{empty}
\begin{center}
	\large\bfseries\MakeUppercase{Resumo}\par
	{\bf \titulo}
\end{center}
\makebox[1.25cm]{}\resumo\par
\bigskip
Palavras-chave: \palavrasChave
%%%%%%%%%%%%%%%%%%%% ABSTRACT %%%%%%%%%%%%%%%%%%%%
\newpage
\thispagestyle{empty}
\begin{center}
	\large\bfseries\MakeUppercase{Abstract}\par
	{\bf \tituloIngles}
\end{center}
\makebox[1.25cm]{}\resumoIngles\par
\bigskip
Keywords: \palavrasChaveIngles
%%%%%%%%%%%%%%%%%%%% LISTA DE ILUSTRAÇÕES %%%%%%%%%%%%%%%%%%%%
\iftoggle{ilustracoes}{%
	\newpage
	\thispagestyle{empty}
%	\begin{center}
%		\MakeUppercase{\large\bf Lista de ilustrações}
%	\end{center}
	\renewcommand{\listfigurename}{LISTA DE ILUSTRAÇÕES}
	\renewcommand\thepage{}
	\listoffigures
	\newpage
	\renewcommand\thepage{\arabic{page}}
}{%
	
}
%%%%%%%%%%%%%%%%%%%% LISTA DE TABELAS %%%%%%%%%%%%%%%%%%%%
\iftoggle{tabelas}{%
	\newpage
	\thispagestyle{empty}
%	\begin{center}
%		\MakeUppercase{\large\bf Lista de tabelas}
%	\end{center}
	\renewcommand{\listtablename}{LISTA DE TABELAS}
	\renewcommand\thepage{}
	\listoftables
	\newpage
	\renewcommand\thepage{\arabic{page}}
}{%
	
}
%%%%%%%%%%%%%%%%%%%% LISTA DE ABREVIATURAS E SIGLAS %%%%%%%%%%%%%%%%%%%%
\iftoggle{abreviaturas}{%
	\newpage
	\thispagestyle{empty}
	\begin{center}
		\large\bfseries\MakeUppercase{Lista de abreviaturas e siglas}
	\end{center}

	\listaabreviacoes

	\newpage
}{%
	
}
%%%%%%%%%%%%%%%%%%%% LISTA DE SÍMBOLOS %%%%%%%%%%%%%%%%%%%%
\iftoggle{simbolos}{%
	\newpage
	\thispagestyle{empty}
	\begin{center}
		\large\bfseries\MakeUppercase{Lista de símbolos}
	\end{center}

	\listasimbolos

	\newpage
}{%
	
}
%%%%%%%%%%%%%%%%%%%% SUMÁRIO %%%%%%%%%%%%%%%%%%%%
\newpage
\thispagestyle{empty}
%\thispagestyle{plainTypeB}
%\begin{center}
%	\MakeUppercase{\large\bf Sumário}
%\end{center}
	\renewcommand{\contentsname}{SUMÁRIO}
	%\renewcommand\thepage{}
	\fancypagestyle{plain}
	{
		\fancyhf{}%
		\renewcommand{\headrulewidth}{0pt}
		\renewcommand{\footrulewidth}{0pt}		
	}	% clear header and footer of plain page because of ToC
	\thispagestyle{empty}
	\tableofcontents
	\thispagestyle{empty}
	\newpage
	\fancypagestyle{plain}
	{
		\fancyhf{}%
		\renewcommand{\headrulewidth}{0pt}
		\renewcommand{\footrulewidth}{0pt}	
		\fancyhead[RO,LE]{\thepage}	
	}
%	\fancypagestyle{fancy}
%	{
%		\renewcommand{\headrulewidth}{0pt}
%		\renewcommand{\footrulewidth}{0pt}
%		\fancyhead[RO,RE,LO,LE,CO,CE]{}
%		\fancyfoot[RO,RE,LO,LE,CO,CE]{}
%		\fancyhead[RO,LE]{\thepage}
%	}	
%		
	%\renewcommand\thepage{\arabic{page}}
}% FIM comando \pretextuais



%\newcommand{\postextuais}{%
%%%%%%%%%%%%%%%%%%%%% REFERÊNCIAS %%%%%%%%%%%%%%%%%%%%
%\newpage
%\thispagestyle{empty}
%\addcontentsline{toc}{section}{Referências}
%%\begin{center}
%%	\MakeUppercase{\large\bf Referências}
%%\end{center}
%\bibliographystyle{plain}
%\bibliography{\jobname}
%}% FIM comando \postextuais


\newtheorem{teorema}{Teorema}[section]
\newtheorem{corolario}{Corolário}[teorema]
\newtheorem{lema}[teorema]{Lema}

\newtheorem{definicao}{Definição}[section]
\newtheorem{exemplo}{Exemplo}[section]

%\AtBeginDocument{\renewcommand{\bibname}{Referências Bibliográficas}\pretextuais}
\AtBeginDocument{\renewcommand{\bibname}{Referências Bibliográficas}}
%\AtEndDocument{\postextuais}




